<?php

namespace Inside\COIV\Providers;

use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * BLANK Service provider.
 *
 * @category Class
 * @package  Inside\\COIV\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        try {
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__.'/../../config/csv.php', 'csv');
            $this->mergeConfigTo(__DIR__.'/../../config/xlsx.php', 'xlsx');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
