<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

final class AddCodeFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        collect(['offices','locations','referents'])
          ->each(
              fn ($contentType) =>
          $bridge->contentTypeCreateOrUpdateField($contentType, 'code', [
            'name' => 'code',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
              'fr' => 'code',
            ],
            'widget' => [
              'type' => BridgeContentType::STRING_WIDGET,
              'settings' => [
                'size' => 60,
                'placeholder' => '',
              ],
              'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
              'max_length' => 255,
              'is_ascii' => false,
              'case_sensitive' => false,
              'cardinality' => 1,
            ],
          ])
          );
    }
}
