<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateLocationsContentTypeMachineName extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('locations');
        $this->finishUp();

        Artisan::call("models:rebuild");

        $contentTypeBridge = new BridgeContentType();

        $contentTypeBridge->contentTypeDelete('localisations');
        $contentTypeBridge->contentTypeDeleteField('user', 'user', 'localisations');

        $fields = collect([
            'locations' => [
                'fr' => "Localisation",
                'weight' => 7,
                'selectable' => true
            ],
            'tools' => [
                'fr' => "Accès rapides",
                'weight' => 10,
                'selectable' => false
            ]
        ])->each(fn (array $data, string $fieldName) => $contentTypeBridge->contentTypeCreateOrUpdateField(
            type:'users',
            fieldName: $fieldName,
            options: [
                'name' => $fieldName,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => $data['weight'],
                'title' => [
                    'fr' => $data['fr'],
                ],
                'widget' => [
                    'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                    'settings' => [],
                    'weight' => $data['weight'],
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => [$fieldName],
                    'cardinality' => -1,
                ],
                'selectable_all' => $data['selectable'],
            ],
            weight: $data['weight']
        ));
    }
}
