import SpacePage from '../pages/SpacePage'
import { fetchSpacePage } from '../components/space/space'

import MasterPage from '../pages/MasterPage'
import { fetchCategories } from '../fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false },
    props: {
      printable: false
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/DirectoryPage'),
    path: {
      fr: '/trombinoscope'
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false },
    props: { commentsEnabled: false }
  },
  {
    name: 'MasterPage',
    component: withFetch(MasterPage)(fetchCategories),
    meta: { disabled: false, content: 'master_pages' },
    path: {
      fr: '/master/:slug'
    }
  },
  {
    name: 'SpacePage',
    path: '/espaces/:slug',
    meta: { content: 'spaces' },
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(
      fetchSpacePage
    )
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
