import { http } from '@inside-library/helpers/Http'

const categoriesRedirection = async ({ data }) => {
  try {
    const { data: parentData } = await http.get(`content/categories`, {
      fields: [{ spaces: ['slug'] }, { master_pages: ['slug'] }],
      filters: {
        'uuid:eq': data.uuid
      }
    })

    const parent = parentData?.[0]?.spaces?.data.length ? 'spaces' : 'master_pages'

    return parent === 'spaces'
      ? {
        name: 'SpacePage',
        params: { slug: parentData?.[0][parent]?.data?.[0]?.slug?.[0] }
      } :
      {
        name: 'MasterPage',
        params: { slug: parentData?.[0][parent]?.data?.[0]?.slug?.[0] }
      }
  } catch (err) {
    throw new Error(err)
  }
}

const latestJobOffersRedirection = async ({ data }) => {
  try {
    const { data: parentData } = await http.get('content/spaces', {
      filters: {
        latest_job_offers: {
          'uuid:eq': data.uuid
        }
      }
    })

    return {
      name: 'SpacePage',
      params: { slug: parentData[0].slug }
    }
  } catch (err) {
    throw new Error(err)
  }
}

export default {
  cardsLinks: {
    add: () => ({
      name: 'HomePage'
    })
  },
  news: {
    disabled: false
  },
  newsCategories: {
    disabled: false
  },
  contractTypes: {
    add: () => '/espace-rh',
    delete: () => '/espace-rh',
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  jobOffers: {
    extends: 'contractTypes'
  },
  categories: {
    add: categoriesRedirection,
    delete: async data => {
      const { data: spaces } = await http.get('content/categories', {
        fields: ['uuid', { spaces: ['uuid', 'slug'] }, { master_pages: ['uuid', 'slug'] }],
        filters: {
          'uuid:eq': data.uuid
        }
      })

      return spaces?.[0]?.spaces?.data.length
        ? {
          name: 'SpacePage',
          params: { slug: spaces?.[0]?.spaces.data?.[0]?.slug?.[0] }
        } :
        {
          name: 'MasterPage',
          params: { slug: spaces?.[0]?.master_pages?.data?.[0]?.slug?.[0] }
        }
    }
  },
  documents: {
    add: async ({ data }) => {
      try {
        const { data: categoryData } = await http.get('content/documents', {
          fields: ['uuid', 'title', { categories: { spaces: ['uuid', 'slug'], master_pages: ['uuid', 'slug'] } }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        const parent = categoryData?.[0]?.categories?.data?.[0]?.spaces?.data.length
          ? 'spaces'
          : 'master_pages'

        return parent === 'spaces'
          ? {
            name: 'SpacePage',
            params: { slug: categoryData?.[0]?.categories?.data?.[0][parent]?.data?.[0]?.slug?.[0] }
          } :
          {
            name: 'MasterPage',
            params: { slug: categoryData?.[0]?.categories?.data?.[0][parent]?.data?.[0]?.slug?.[0] }
          }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: categoryData } = await http.get('content/documents', {
          fields: ['uuid', 'title', { categories: { spaces: ['uuid', 'slug'], master_pages: ['uuid', 'slug'] } }],
          filters: {
            'uuid:eq': uuid
          }
        })

        const parent = categoryData?.[0]?.categories?.data?.[0]?.spaces?.data.length
          ? 'spaces'
          : 'master_pages'

        return parent === 'spaces'
          ? {
            name: 'SpacePage',
            params: { slug: categoryData?.[0]?.categories?.data?.[0][parent]?.data?.[0]?.slug?.[0] }
          } :
          {
            name: 'MasterPage',
            params: { slug: categoryData?.[0]?.categories?.data?.[0][parent]?.data?.[0]?.slug?.[0] }
          }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  externalLinks: {
    add: async ({ data }) => {
      try {
        const { data: categoryData } = await http.get('content/external_links', {
          fields: ['uuid', 'title', { categories: { spaces: ['uuid', 'slug'], master_pages: ['uuid', 'slug'] } }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        const parent = categoryData?.[0]?.categories?.data?.[0]?.spaces?.data.length
          ? 'spaces'
          : 'master_pages'

        return parent === 'spaces'
          ? {
            name: 'SpacePage',
            params: { slug: categoryData?.[0]?.categories?.data?.[0][parent]?.data?.[0]?.slug?.[0] }
          } :
          {
            name: 'MasterPage',
            params: { slug: categoryData?.[0]?.categories?.data?.[0][parent]?.data?.[0]?.slug?.[0] }
          }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: categoryData } = await http.get('content/external_links', {
          fields: ['uuid', 'title', { categories: { spaces: ['uuid', 'slug'], master_pages: ['uuid', 'slug'] } }],
          filters: {
            'uuid:eq': uuid
          }
        })

        const parent = categoryData?.[0]?.categories?.data?.[0]?.spaces?.data.length
          ? 'spaces'
          : 'master_pages'

        return parent === 'spaces'
          ? {
            name: 'SpacePage',
            params: { slug: categoryData?.[0]?.categories?.data?.[0][parent]?.data?.[0]?.slug?.[0] }
          } :
          {
            name: 'MasterPage',
            params: { slug: categoryData?.[0]?.categories?.data?.[0][parent]?.data?.[0]?.slug?.[0] }
          }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  masterPages: {
    add: ({ data }) => {
      return {
        name: 'MasterPage',
        params: { slug: data.slug[0] }
      }
    }
  },
  latestJobOffers: {
    add: latestJobOffersRedirection,
    delete: latestJobOffersRedirection
  }
}
