export default {
  globals: {
    notificationRedirectionsContentTypes: ['news'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      })
    }
  },
  'inside-administration': {
    disabledAdvancedSettingsFields: ['ged_enable_likes']
  },
  'inside-news': {
    bookmarkEnabled: false,
    authorEnabled: true
  },
  'inside-users': {
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  }
}
