import { http } from '@inside-library/helpers/Http'

const fetchCategories = async ({ $route }) => {
  try {
    const { data } = await http.get('content/categories', {
      fields: [
        'spaces',
        'image',
        'master_pages',
        'weight',
        'title',
        'content_type',
        'uuid',
        'admin',
        {
          documents: {
            fields: [
              'uuid',
              'title',
              'file',
              'has_section',
              'content',
              'slug',
              'link',
              'admin',
              'content_type',
              'content',
              'created_at'
            ],
            filters: { reverse: true }
          }
        },
        {
          external_links: {
            fields: ['uuid', 'title', 'content_type', 'admin', 'link'],
            filters: { reverse: true }
          }
        },
        {
          pages: {
            fields: ['uuid', 'title', 'content_type', 'admin', 'content'],
            filters: { reverse: true }
          }
        }
      ],
      filters: {
        status: 1,
        sort: 'weight:asc',
        ...($route.meta.content === 'master_pages'
          ? { master_pages: { 'slug:eq': $route.params.slug } }
          : { spaces: { 'slug:eq': $route.params.slug } })
      }
    })

    return data
  } catch (error) {
    throw new Error(error)
  }
}

const fetchCardLink = async () => {
  try {
    const { data } = await http.get('content/cards_links', {
      fields: [
        'uuid',
        'title',
        'admin',
        'image',
        'link',
        'weight',
        'content_type'
      ],
      filters: { 'status:eq': 1, sort: 'weight:asc', limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchCategories, fetchCardLink }
