import { http } from '@inside-library/helpers/Http'

export const fetchSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'description',
        'header_image',
        'admin',
        'presentation',
        'presentation_image',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'phone'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          latest_job_offers: {
            fields: ['uuid', 'title', 'file'],
            filters: {
              sort: 'published_at:desc',
              limit: 3,
              'status:eq': 1
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
