<?php

namespace Inside\CNOS\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Inside\Host\Bridge\BridgeAuthentication;

class CNOSMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $bridge = new BridgeAuthentication();

        define('BASE_URI_PATH', '/organization-chart');
        if (strpos($_SERVER['REQUEST_URI'], BASE_URI_PATH) === 0 && $bridge->isAuthenticated()) {
            define('BASE_DOC_PATH', env('CNOS_BASE_ORGANIZATION_DOC_PATH', '/app/organization-chart'));
            $current_uri = str_replace(BASE_URI_PATH, '', $_SERVER['REQUEST_URI']);

            if (in_array($current_uri, ['', '/'])) {
                header('Location: ' . BASE_URI_PATH . '/index.html');
                exit;
            }

            $current_file = BASE_DOC_PATH . $current_uri;

            if (file_exists($current_file)) {
                $current_file_mime = (string) mime_content_type($current_file);
                $current_file_data = pathinfo($current_file);

                switch ($current_file_data['extension']) { // @phpstan-ignore-line
                    case 'js':
                        header('Content-Type: application/javascript');
                        break;
                    case 'css':
                        header('Content-Type: text/css');
                        break;
                    default:
                        // For all others downloadable files of the GED
                        if (strpos($current_file_mime, 'application/') !== false) {
                            header('Content-Description: File Transfer');
                            header('Content-Type: ' . $current_file_mime);
                            header('Content-Disposition: attachment; filename='.basename($current_file));
                            header('Content-Transfer-Encoding: binary');
                            header('Expires: 0');
                            header('Cache-Control: must-revalidate');
                            header('Pragma: public');
                            header('Content-Length: ' . filesize($current_file));
                        }
                        break;
                }
                ob_clean();
                flush();
                readfile($current_file);
                exit;
            } else {
                http_response_code(404);
                die('404 / Ressource not found.');
            }
        }
        return $next($request);
    }
}
