<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => false
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/cnos-back/resources/assets/img/newsletter/header_newsletter.jpg',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#022560',
            'showIntroduction'   => true,
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#022560',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#022560',
            'link' => [
                'sectionLinkUrl'   => 'evenements',
                'sectionTextColor' => '#022560',
            ],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#022560',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/FranceOlympique',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/FranceOlympique',
            ],
            'sportenfrance' => [
                'url' => 'https://www.sportenfrance.com',
                'imageUrl' => url('vendor/maecia/cnos-back/resources/assets/img/newsletter/arrow-right-footer.png'),
                'titleStrKey' => 'Sport en France'
            ],
        ],
    ],
];
