<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Layout\Models\LayoutPath;
use Inside\Layout\Models\Layout;

class SeedCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        collect([
            ['title' => 'Événements', 'custom_slug' => 'calendar', 'redirection_page' => 'EventsCalendarPage'],
            ['title' => 'Annuaire', 'custom_slug' => 'directory', 'redirection_page' => 'DirectoryPage'],
            ['title' => 'Base documentaire', 'custom_slug' => 'ged', 'redirection_page' => 'GetPage'],
            ['title' => 'Outils', 'custom_slug' => 'tools', 'redirection_page' => 'ToolsPage'],
            ['title' => 'Mouvements', 'custom_slug' => 'newcomers', 'redirection_page' => 'NewcomersListingPage'],
            ['title' => 'Covoiturage', 'custom_slug' => 'carpooling', 'redirection_page' => 'CarpoolingPage'],
            ['title' => 'Projects', 'custom_slug' => 'projects-listing', 'redirection_page' => 'ProjectsListingPage'],
            ['title' => 'Murs de discussion', 'custom_slug' => 'walls', 'redirection_page' => 'WallPage'],
        ])->each(fn ($custom) => $bridge->contentInsert(type: 'custom', data: $custom, fromCli: true));

        LayoutPath::with('layout')
            ->whereIn('path', ['espace', 'home', 'espace-rh'])
            ->get()
            ->pluck('layout')
            ->each(fn (Layout $layout) => $layout->delete());
    }
}
