<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditUserPhoneField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'phone');
        $bridge->contentTypeCreateField('users', 'phone', [
            'name' => 'phone',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'editable' => true,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Téléphones',
            ],
            'widget' => [
                'type' => BridgeContentType::TEXT_WIDGET,
                'weight' => 4,
                'group' => 'group_contact',
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ], 4);
    }

    public function down(): void
    {
    }
}
