<?php

namespace Inside\CNOS\Providers;

use Inside\Providers\ServiceProvider as BaseServiceProvider;

/**
 * SID2 Service provider.
 *
 * @category Class
 * @package  Inside\SID2\Providers\ServiceProvider
 * @author   Maecia <contact@feldoe.net>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(
            __DIR__ . '/../../config/scheduler.php',
            'scheduler'
        );

        $this->mergeConfigTo(
            __DIR__ . '/../../config/azuread.php',
            'azuread'
        );

        if (method_exists($this->app, 'middleware')) {
            $this->app->middleware([
                \Inside\CNOS\Http\Middleware\CNOSMiddleware::class,
            ]);
        }
    }
}
