<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class createLatestJobOffersType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridgeType = new BridgeContentType();
        $bridgeType->contentTypeDelete('job_offers_banner');

        $this->bootUp(__FILE__);
        $this->migrateContent('latest_job_offers', false);
        $this->finishUp();

        $bridgeType->contentTypeCreateOrUpdateField(
            'spaces',
            'latest_job_offers',
            [
                'name' => 'latest_job_offers',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'fr' => 'Dernières offres d\'emploi',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'weight' => 12,
                ],
                'settings' => [
                    'target_type' => ['latest_job_offers'],
                    'cardinality' => -1,
                ],
            ],
        );
    }

    public function down(): void
    {
    }
}
