<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class ReplaceMachineNameLinkInToolsShortcuts extends Migration
{
    public function up(): void
    {
        if (!Schema::hasContentType('tools')) {
            return;
        }
        $bridgeType = new BridgeContentType();
        $bridge = new BridgeContent();
        $data = [];

        $tools = Tools::get();
        foreach ($tools as $tool) {
            $data[$tool['uuid']] = $tool['tools_link'];
        }
        $bridgeType->contentTypeDeleteField('node', 'tools', 'tools_link');

        $bridgeType->contentTypeCreateOrUpdateField('tools', 'tools_link', [
            'name' => 'tools_link',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'editable' => false,
            'search_result_field' => false,
            'required' => true,
            'title' => [
                'fr' => 'Lien',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        foreach ($tools as $tool) {
            foreach ($data as $key => $value) {
                if ($tool->uuid === $key) {
                    $bridge->contentUpdate('tools', [
                        'uuid' => $tool->uuid,
                        'tools_link' => $value
                    ]);
                }
            }
        }
    }

    public function down(): void
    {
    }
}
