<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddUserAzureadField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('users', 'azuread_account', [
            'name' => 'azuread_account',
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'searchable' => false,
            'search_result_field' => false,
            'default' => false,
            'searchable_filter' => false,
            'editable' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Est un compte azuread',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'azuread_account');
    }
}
