<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'name' => 'spaces',
        'title' => [
            'fr' => 'Espaces'
        ],
    ],
    'fields' => [
        [
            'name'                => 'header_image',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => true,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Image header'
            ],
            'description'         => [
                'fr' => ''
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::IMAGE_FIELD,
            'settings'            => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'   => '',
                    'alt'    => '',
                    'title'  => '',
                    'width'  => null,
                    'height' => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
        [
            'name'                => 'description',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Descriptiion'
            ],
            'description'         => [
                'fr' => ''
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows'        => 5,
                    'placeholder' => '',
                ],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'settings'            => [
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'presentation_image',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Image bloc présentation'
            ],
            'description'         => [
                'fr' => ''
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::IMAGE_FIELD,
            'settings'            => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'   => '',
                    'alt'    => '',
                    'title'  => '',
                    'width'  => null,
                    'height' => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
        [
            'name'                => 'presentation',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Présentation'
            ],
            'description'         => [
                'fr' => ''
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows'        => 5,
                    'placeholder' => '',
                ],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'settings'            => [
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'contacts',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Contacts Clés'
            ],
            'description'         => [
                'fr' => ''
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [
                    'rows'        => 5,
                    'placeholder' => '',
                ],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'settings'            => [
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ]
    ],
];
