<?php

use Inside\Host\Bridge\BridgeContentType;

return [
  'options' => [
    'translatable'        => false,
    'searchable'          => false,
    'global_searchable'   => false,
    'aliasable'           => true,
    'permissible'         => true,
    'categorizable'       => true,
    'name'                => 'custom',
    'title'               => [
      'fr' => 'Pages personnalisées',
    ],
  ],
  'fields' => [
    [
      'name'                  => 'image',
      'searchable'            => false,
      'translatable'          => false,
      'default'               => false,
      'search_result_field'   => false,
      'required'              => false,
      'weight'                => 6,
      'title'                 => [
        'fr' => 'Image du header',
      ],
      'description'           => [
        'fr' => '',
      ],
      'widget'                => [
        'type'      => BridgeContentType::IMAGE_WIDGET,
        'settings'  => [
          'progress_indicator'  => 'throbber',
          'preview_image_style' => 'thumbnail',
        ],
        'weight'    => 6,
        'group'     => 'group_advanced_options',
      ],
      'type'                  => BridgeContentType::IMAGE_FIELD,
      'settings'              => [
        'uri_scheme'      => 'public',
        'default_image'   => [
          'uuid'    => '',
          'alt'     => '',
          'title'   => '',
          'width'   => null,
          'height'  => null,
        ],
        'target_type'     => 'file',
        'display_field'   => false,
        'display_default' => false,
        'cardinality'     => 1,
      ],
    ],
    [
      'name'                => 'introduction',
      'searchable'          => false,
      'translatable'        => false,
      'default'             => false,
      'search_result_field' => false,
      'required'            => false,
      'weight'              => 2,
      'title'               => [
        'fr' => 'Introduction',
      ],
      'description'         => [
        'fr' => '',
      ],
      'widget'              => [
        'type'      => BridgeContentType::LONGTEXT_WIDGET,
        'settings'  => [
          'rows'        => 5,
          'placeholder' => '',
        ],
        'weight'    => 2,
      ],
      'type'        => BridgeContentType::TEXTAREA_FIELD,
      'settings'    => [
        'case_sensitive'  => false,
        'cardinality'     => 1,
      ],
    ],
  ]
];
