<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'counters',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Compteur',
        ],
    ],
    'fields' => [
        [
            'name' => 'date',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Date et heure de début',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'counter_content',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu'
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'logo',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'background_color',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Couleur de fond',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'default' => '#B19665',
        ]
    ],
];
