<?php

use Illuminate\Support\Str;
use Inside\Host\Bridge\BridgeContent;

/**
 * Try to determine best language with parameters
 *
 * @param mixed $user
 * @param BridgeContent $bride
 * @param string $attribute
 * @param string $contentType
 * @return array|null
 * @throws Exception
 */

function getEntityReference($user, \Inside\Host\Bridge\BridgeContent $bride, string $attribute, string $contentType): ?array
{
    if (!isset($user->{$attribute})) {
        return null;
    }

    $uuids = [];
    $title = $user->{$attribute};

    if ($title) {
        $entity = call_user_func(type_to_class($contentType).'::query')
            ->where('title', $title)
            ->first();

        if ($entity) {
            $uuid = $entity->uuid;
        } else {
            $uuid = $bride->contentInsert(
                $contentType,
                [
                    'type' => 'node',
                    'bundle' => $contentType,
                    'title' => $title,
                    'uid' => 1,
                ]
            );
        }

        $uuids[] = $uuid;
    }
    return $uuids ?: null;
}

return [
    /**
     * Apply a post filter on users
     */
    'postfilter'    => function ($users) {
        return $users->reject(
            fn ($user) =>
            !$user->accountEnabled ||
            $user->companyName !== "CNOSF" ||
            $user->onPremisesExtensionAttributes->extensionAttribute1 === '1'
        );
    },

    'sync_attributes' => [
        'name' => 'mail',
        'email' => 'mail',
        'langcode' => function () {
            return 'fr';
        },
        'firstname' => function ($user) {
            if (!isset($user->givenName)) {
                return null;
            }

            return Str::ucfirst(Str::lower($user->givenName));
        },
        'lastname' => 'surname',
        'phone' => function ($user) {
            return implode(", ", $user->businessPhones);
        },
        'function' => 'jobTitle',
        'office' => 'officeLocation',
        'mobile' => 'mobilePhone',
        'poles' => function ($user, BridgeContent $bridge) {
            return getEntityReference($user, $bridge, 'department', 'poles');
        },
        'azuread_account' => function () {
            return true;
        }
    ]
];
