<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class UpdateUsersFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->changeFieldFormOptions(
            type: 'users',
            fieldName: 'birthday',
            displayed: false
        );

        $usersFields = [
            'firstname' => [
                'fr' => 'Prénom'
            ],
            'lastname' => [
                'fr' => 'Nom'
            ],
        ];

        foreach ($usersFields as $userField => $titles) {
            $bridge->contentTypeCreateOrUpdateField(
                type: 'users',
                fieldName: $userField,
                options: [
                    'required' => true,
                    'title' => $titles,
                ]
            );
        }

        if (InsideSchema::hasModel('roles')) {
            $bridge->contentTypeDeleteField(
                entityType: 'user',
                type: 'user',
                fieldName: 'roles',
            );

            $bridge->contentTypeDelete(
                type: 'roles'
            );
        }
    }
}
