<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MakeToolsCategoriesListingsFieldRequiredForToolsCategories extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'tools_categories',
            fieldName: 'tools_categories_listings',
            options: [
                'required' => true,
                'title' => [
                    'fr' => 'Listing d\'outils',
                    'en' => 'Tool List',
                    'nl' => 'Gereedschapslijst',
                    'pt' => 'Lista de ferramentas',
                    'es' => 'Lista de herramientas',
                    'de' => 'Werkzeugliste',
                ],
            ],
        );
    }
}
