<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
    ],
    'fields' => [
        [
            'name' => 'inspiration',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Celui qui t\'inspire',
            ],
            'widget' => [
                'group' => 'group_collaborateurs',
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
        [
            'name' => 'want_to_be',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Celui que tu voudrais être',
            ],
            'widget' => [
                'group' => 'group_collaborateurs',
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
        [
            'name' => 'biography',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Biographie',
            ],
            'widget' => [
                'group' => 'group_elu',
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
        [
            'name' => 'responsability',
            'searchable' => true,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Autres responsabilités',
            ],
            'widget' => [
                'group' => 'group_elu',
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],        [
            'name' => 'roles_users',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Rôles',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['roles_users'],
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'is_prof',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Professeur',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
