<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
        'translatable' => false,
    ],
    'fields' => [
        [
            'name' => 'firstname',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Prénom',
                'en' => 'First name',
                'nl' => 'Voornaam',
                'pt' => 'Primeiro nome',
                'es' => 'Nombre',
                'de' => 'Vorname',
            ],
            'widget' => [
                'group' => 'group_infos',
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'lastname',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Nom',
                'en' => 'Last name',
                'nl' => 'Naam',
                'pt' => 'Nome',
                'es' => 'Apellido',
                'de' => 'Nachname',
            ],
            'widget' => [
                'group' => 'group_infos',
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'function',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Fonction',
                'en' => 'Function',
                'nl' => 'Functie',
                'pt' => 'Função',
                'es' => 'Función',
                'de' => 'Funktion',
            ],
            'widget' => [
                'group' => 'group_collaborateurs',
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'departments',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Départements',
            ],
            'description' => [],
            'widget' => [
                'group' => 'group_infos',
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['departments'],
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'mobile_phone',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Mobile',
                'en' => 'Mobile phone',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'phone',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Téléphone',
                'en' => 'Phone',
                'nl' => 'Telefoon',
                'pt' => 'Telefone',
                'es' => 'Teléfono',
                'de' => 'Telefon',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'inspiration',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Celui qui t\'inspire',
            ],
            'widget' => [
                'group' => 'group_collaborateurs',
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
        [
            'name' => 'want_to_be',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Celui que tu voudrais être',
            ],
            'widget' => [
                'group' => 'group_collaborateurs',
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
        [
            'name' => 'linkedin',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Linkedin',
            ],
            'widget' => [
                'group' => 'group_contact',
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 20,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
        [
            'name' => 'biography',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Biographie',
            ],
            'widget' => [
                'group' => 'group_elu',
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
        [
            'name' => 'responsability',
            'searchable' => true,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Autres responsabilités',
            ],
            'widget' => [
                'group' => 'group_elu',
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
    ],
];
