<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'banner'       => [
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#333333'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#EA4B3C',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#EA4B3C',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#EA4B3C',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#EA4B3C',
            ],
        ],
        'new_members' => [
            'sectionTitleStrKey' => 'newsletter.new_members_title',
            'introductionLength' => 50,
            'introductionFieldName' => 'movements_description',
            'types'           => ['movements'],
            'link' => [
                'sectionLinkStrKey' => 'newsletter.see_all_new_members',
                'sectionLinkUrl'   => 'movements',
                'sectionTextColor' => '#EA4B3C',
            ],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#EA4B3C',
        'links' => [
            'globe' => [
                'titleStrKey' => 'Site Web',
                'url' => 'https://www.cma-alsace-moselle-grandest.fr',
            ],
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#F0F0F0',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
