<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class RenameEstablishmentsFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $modelsWithEstablishmentsField = InsideSchema::getModelsWithField('establishments');

        collect($modelsWithEstablishmentsField)->each(function ($model) use ($bridge) {
            $bridge->contentTypeCreateOrUpdateField(
                type: $model,
                fieldName: 'establishments',
                options: [
                    'title' => [
                        'fr' => 'Établissement',
                    ]
                ]
            );
        });

        $bridge->changeContentTypeTitle(
            type: 'establishments',
            titles: [
                'fr' => 'Établissement'
            ]
        );
    }
}
