<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\ToolsCategories;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class SetUsersDefaultTools extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        $tool = Tools::query()->where('title', 'Chronos')->first();
        $toolCategory = ToolsCategories::query()->where('title', 'Outils par défaut')->first();

        if (empty($toolCategory)) {
            throw new Exception('Category "Outils par défaut" not found !');
        }

        if (empty($tool)) {
            $toolsData = [
                'bundle'    => 'tools',
                'tools_link' => env('APP_URL', '') . '/outils',
                'title'     => 'Outils',
                'icon'      => '{"name":"empty"}',
                'type'      => 'node',
                'tools_categories' => $toolCategory->uuid,
                'weight'    => 0,
                'langcode'  => 'fr',
            ];

            $uuid = $bridge->contentInsert('tools', $toolsData);
            $toolsData['langcode'] = 'fr';
            $toolsData['title'] = 'Chronos';
            $bridge->contentUpdate('tools', $toolsData);
        } else {
            $uuid = $tool->uuid;
        }

        $users = Users::all();

        foreach ($users as $user) {
            $tools = $user->tools;
            $tools = $tools->pluck('uuid')->toArray();
            $tools[1] = $uuid;

            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $tools
            ]);
        }
    }
}
