<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;

class FixTranslation extends Migration
{
    public function up(): void
    {
        $fields =
            [
                'fr' => 'Auteur',
                'en' => 'Author',
                'es' => 'Autor',
            ];

        $models = InsideSchema::getModelsWithField('authors');

        foreach ($models as $model) {
            InsideSchema::updateFieldOption($model, 'authors', 'title', $fields);
        }
    }
}
