<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
    ],
    'fields' => [
        [
            'name' => 'mobile_phone',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Mobile',
                'en' => 'Mobile phone',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_PHONE_WIDGET,
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'intern_number',
            'searchable' => true,
            'translatable' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Numéro interne',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'missions',
            'searchable' => true,
            'translatable' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Missions',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'establishments',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'ESMS',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['establishments'],
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'departments',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Départements',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['departments'],
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'link_teams',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Teams',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 20,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
        [
            'name' => 'manager',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Manager',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 7,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'services',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Services',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['services'],
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'linkedin',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Linkedin',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 20,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'inspiration',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Celui qui t\'inspire',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
        [
            'name' => 'want_to_be',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Celui que tu voudrais être',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => true,
        ],
        [
            'name' => 'biography',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Biographie',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'responsability',
            'searchable' => true,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Autres responsabilités',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'job',
            'searchable' => true,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Métier',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'positions',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Titre',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['positions'],
                'cardinality' => 1,
            ],
            'editable' => false,
        ],
        [
            'name' => 'roles',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Rôles',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['roles'],
                'cardinality' => 1,
            ],
            'editable' => false,
        ]
    ],
];
