import TabsSpacesListingPage from '../pages/tabs-spaces/TabsSpacesListingPage'
import TabsSpacePage from '../pages/tabs-spaces/TabsSpacePage'
import {
  fetchTabsSpacesListing,
  fetchTabSpacePage
} from '../components/tabs-spaces/tabs'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'published_at:lte': 'now()',
        'status:eq': 1
      },
      toolsFilters: {
        sort: 'weight:asc',
        'published_at:lte': 'now()',
        'status:eq': 1
      }
    }
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false },
    component: withFetch(TabsSpacePage, { size: 'xxl' })(fetchTabSpacePage)
  },
  {
    name: 'TabsSpacesListingPage',
    path: '/espaces/:slug',
    component: withFetch(TabsSpacesListingPage, { size: 'xxl' })(
      fetchTabsSpacesListing
    ),
    meta: { disabled: false }
  }
]
