import { http } from '@inside-library/helpers/Http'

export const fetchCardLink = async () => {
  try {
    const { data } = await http.get('content/cards_links', {
      fields: [
        'uuid',
        'title',
        'admin',
        'image',
        'link',
        'published_at',
        'content_type'
      ],
      filters: { 'status:eq': 1, sort: 'weight:asc', limit: 3 }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchBlockImage = async () => {
  try {
    const { data } = await http.get('content/block_images', {
      fields: [
        'uuid',
        'image',
        'title',
        'link',
        'admin',
        'content_type',
        'open_in_new_tab'
      ],
      filters: { 'status:eq': 1, sort: 'weight:asc', limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchInstagram = async () => {
  try {
    const { data } = await http.get('content/instagrams', {
      fields: ['uuid', 'content'],
      filters: { 'status:eq': 1, limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
