import { http } from '@inside-library/helpers/Http'

export const fetchTabsSpacesListing = async ({ $route }) => {
  try {
    const { data: spaceCategorie } = await http.get(
      'content/space_categories',
      {
        fields: [
          'uuid',
          'title',
          'admin',
          'content_type',
          'introduction',
          'banner'
        ],
        filters: { 'slug:eq': $route.params.slug }
      }
    )

    if (spaceCategorie) {
      const { data: tabsSpaces } = await http.get('content/tabs_spaces', {
        fields: [
          'uuid',
          'title',
          'admin',
          'content_type',
          'image',
          'introduction',
          'slug',
          {
            space_categories: {
              fields: ['uuid', 'slug']
            }
          }
        ],
        filters: {
          space_categories: {
            'slug:eq': $route.params.slug
          },
          sort: 'weight:asc',
          status: 1
        }
      })

      return { banner: spaceCategorie[0], tabsSpaces }
    }
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchTabSpacePage = async ({ $route }) => {
  try {
    const { data: tabsSpaces } = await http.get('content/tabs_spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'image',
        'banner',
        'color',
        'introduction',
        'slug',
        {
          space_categories: {
            fields: ['uuid', 'slug']
          }
        }
      ],
      filters: {
        'slug:eq': $route.params.slug,
        sort: 'weight:asc',
        status: 1
      }
    })

    return tabsSpaces[0]
  } catch (err) {
    throw new Error(err)
  }
}
