<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddOpenInNewTabInBlockImage extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'block_images',
            fieldName: 'open_in_new_tab',
            options: [
                'name' => 'open_in_new_tab',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => -1,
                'title' => [
                    'fr' => 'Ouvrir dans un nouvel onglet',
                ],
                'description' => [
                    'fr' => 'Si cocher, le lien s\'ouvrira dans un nouvel onglet lors du clic sur l\'image',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => -1,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
                ],
            weight: -1
        );
    }
}
