<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;

class CreateContentType extends Migration
{
    use CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('tools_categories', false);
        $this->migrateContent('tools', false);
        $this->migrateContent('users', false);
        $this->migrateContent('news_categories', false);
        $this->migrateContent('news', false);
        $this->migrateContent('events_categories', false);
        $this->migrateContent('events', false);
        $this->migrateContent('folders', false);
        $this->migrateContent('documents', false);
        $this->migrateContent('space_categories', false);
        $this->migrateContent('tabs_spaces', false);
        $this->migrateContent('tabs', false);
        $this->migrateContent('tabs_pages', false);
        $this->migrateContent('image_with_texts', false);
        $this->migrateContent('cards_links', false);

        ContentBlueprints::generateContent('faq_categories');
        ContentBlueprints::generateContent('faq_questions');

        ContentBlueprints::generateContent(contentType: 'flash_news');

        $this->finishUp();

        Artisan::call("models:rebuild");
    }
}
