import SpacePage from '../pages/spaces/SpacePage'
import SpacePagesPage from '../pages/spaces/SpacePagesPage'

import { fetchSpacePage, fetchSpacePagesPage } from '../fetch/spaces'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'SpacePage',
    path: '/espace/:slug',
    component: withFetch(SpacePage, { size: 'xxl' })(fetchSpacePage),
    meta: { content: 'spaces' }
  },
  {
    name: 'SpacePagesPage',
    path: '/espace/:slug/pages',
    component: withFetch(SpacePagesPage, { size: 'xxl' })(fetchSpacePagesPage),
    meta: { content: 'spaces' }
  },
  {
    name: 'ToolsPage',
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    },
    meta: { disabled: false }
  },
  {
    name: 'RoomsListingPage',
    path: '/reservations-salles',
    component: () => import('../pages/agenda/AgendaListingPage'),
    props: {
      endpoint: 'content/rooms',
      add: ['rooms'],
      redirectionPage: 'RoomsPage',
      page: 'rooms-listing'
    }
  },
  {
    name: 'RoomsPage',
    path: '/reservations-salles/:slug',
    component: () => import('@inside-agenda/components/pages/AgendaPage'),
    props: {
      back: {
        href: { name: 'RoomsListingPage' }
      }
    }
  },
  {
    name: 'VehiclesListingPage',
    path: '/reservations-vehicules',
    component: () => import('../pages/agenda/AgendaListingPage'),
    props: {
      endpoint: 'content/vehicles',
      add: ['vehicles'],
      redirectionPage: 'VehiclesPage',
      page: 'vehicles-listing'
    }
  },
  {
    name: 'VehiclesPage',
    path: '/reservations-vehicules/:slug',
    component: () => import('@inside-agenda/components/pages/AgendaPage'),
    props: {
      back: {
        href: { name: 'VehiclesListingPage' }
      },
      endpoint: 'vehicles',
      extraFields: [
        {
          vehicles_category: {
            fields: ['uuid', 'title', 'color'],
            filters: { 'status:eq': 1 }
          }
        }
      ]
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'JobsListingPage',
    meta: { disabled: false }
  }
]
