import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => {
      return {
        name: 'SpacePage',
        params: { slug: data.slug[0] }
      }
    }
  },
  pagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    }),
    globalSearch: async ({ data }) => {
      const { data: Space } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacePagesPage',
          params: {
            slug: Space[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacePagesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get('content/spaces_pages', {
        fields: ['uuid', { pages_categories: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: Space } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': pagesCategories[0].pages_categories.uuid }
      })

      return {
        route: {
          name: 'SpacePagesPage',
          params: {
            slug: Space[0].spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  roomsCategories: {
    add: () => {
      return {
        name: 'RoomsListingPage'
      }
    }
  },
  rooms: {
    add: ({ data }) => {
      return {
        name: 'RoomsPage',
        params: { slug: data.slug[0] }
      }
    }
  },
  vehiclesCategories: {
    add: () => {
      return {
        name: 'VehiclesListingPage'
      }
    }
  },
  vehicles: {
    add: ({ data }) => {
      return {
        name: 'VehiclesPage',
        params: { slug: data.slug[0] }
      }
    }
  }
}
