import { getContentImage } from '@inside-library/helpers/Image'

export default {
  'inside-agenda': {
    allowedViews: ['week', 'month']
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'avatar')
        }),
        requestFields: [
          'uuid',
          'image',
          'firstname',
          'lastname',
          'phone',
          { functions: ['title'] }
        ]
      }
    }
  }
}
