import { http } from '@inside-library/helpers/Http'

export const fetchSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'presentation',
        'banner',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'functions',
              'email',
              'mobile'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type',
              {
                tools_categories: [
                  'uuid',
                  { tools_categories_listings: ['uuid', 'slug'] }
                ]
              }
            ],
            filters: {
              'status:eq': 1,
              limit: 2
            }
          }
        },
        {
          documents: [
            'uuid',
            'title',
            'file',
            'has_section',
            'admin',
            'content_type',
            'published_at'
          ]
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'introduction',
                    'published_at',
                    'image',
                    'content_type',
                    { news_categories: ['uuid', 'title', 'color'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          pages_categories: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpacePagesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'image',
        'description'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
