<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateReservationEquipmentsField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDeleteField('node', 'rooms', 'equipments');
        $this->getBridge()?->contentTypeDeleteField('node', 'vehicles', 'equipments');

        $field = [
            'name' => 'equipments',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Matériel',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ];

        $this->getBridge()?->contentTypeCreateOrUpdateField('rooms', 'equipments', $field, 4);
        $this->getBridge()?->contentTypeCreateOrUpdateField('vehicles', 'equipments', $field, 4);
        $this->finishUp();
    }
}
