<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Sections\Video;
use Inside\Host\Bridge\BridgeContent;

class SetDownloadButtonToVideoParagraphToNull extends Migration
{
    public function up(): void
    {
        $bridgeContent = new BridgeContent();
        Video::all()->each(
            fn ($contentType) =>
            $bridgeContent->contentUpdate(
                type: class_to_type($contentType->sectionable_type),
                data: [
                    'uuid' => $contentType->sectionable_uuid,
                    'content' => [
                        [
                            'type' => 'paragraph',
                            'bundle' => 'video',
                            'uuid' => $contentType->uuid,
                            'allow_download' => null,
                        ],
                    ],
                ]
            )
        );
    }
}
