<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class DeleteDirectionsContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDeleteField('user', 'user', 'directions');
        $this->getBridge()?->contentTypeDelete('directions');
        $this->getBridge()?->contentTypeUpdate('services', ['title' => ['fr' => 'Direction / Service']]);
        $this->getBridge()?->changeFieldTitle('users', 'services', ['fr' => 'Direction / Service']);
        $this->finishUp();
    }
}
