<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class SeedCustoms extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $customs = collect([
            [
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
                'title' => 'Actualités',
            ],
            [
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
                'title' => 'Outils',
            ],
            [
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
                'title' => 'Événements',
            ],
            [
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
                'title' => 'Médiathèque',
            ],
            [
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
                'title' => 'Annuaire',
            ],
            [
                'custom_slug' => 'organizational-charts',
                'redirection_page' => 'OrganizationsListingPage',
                'title' => 'Organigrammes',
            ],
            [
                'custom_slug' => 'rooms-listing',
                'redirection_page' => 'RoomsListingPage',
                'title' => 'Réservation salles de réunion',
            ],
            [
                'custom_slug' => 'vehicles-listing',
                'redirection_page' => 'VehiclesListingPage',
                'title' => 'Réservation véhicules',
            ],
        ]);

        $bridge = new BridgeContent();

        $customs->each(function (array $custom) use ($bridge) {
            $existing = Custom::where('redirection_page', $custom['redirection_page'])->first();

            if ($existing instanceof Custom) {
                $custom['uuid'] = $existing->uuid;
            }

            $bridge->contentInsert('custom', $custom, ! isset($custom['uuid']));
        });
    }
}
