<?php

declare(strict_types=1);

use Adldap\Models\Entry;
use Inside\Host\Bridge\BridgeContent;

if (! function_exists('get_entity_reference')) {
    function get_entity_reference(?string $value, string $contentType, BridgeContent $bridge, string $identifier = 'title', bool $create = true): ?string
    {
        if (! $value) {
            return null;
        }

        $existing = type_to_class($contentType)::where($identifier, $value)->first()?->uuid;

        if (! $create) {
            return $existing;
        }

        return $existing ?? $bridge->contentInsert($contentType, [$identifier => $value]);
    }
}

return [
    'sync_attributes' => [
        'name' => 'userPrincipalName',
        'email' => 'mail',
        'firstname' => 'givenname',
        'lastname' => 'sn',
        'phone' => fn (Entry $user) => $user->hasAttribute('telephoneNumber')
            ? str($user->getFirstAttribute('telephoneNumber'))->before('/')->trim()->toString()
            : null,
        'mobile_phone' => fn (Entry $user) => $user->hasAttribute('mobile')
            ? str($user->getFirstAttribute('mobile'))->trim()->toString()
            : null,
        'ip_phone' => fn (Entry $user) => $user->hasAttribute('ipphone')
            ? str($user->getFirstAttribute('ipphone'))->trim()->toString()
            : null,
        'functions' => fn (Entry $user, BridgeContent $bridge) => get_entity_reference($user->getFirstAttribute('title'), 'functions', $bridge),
        'services' => fn (Entry $user, BridgeContent $bridge) => get_entity_reference($user->getFirstAttribute('department'), 'services', $bridge),
        'communities' => fn (Entry $user, BridgeContent $bridge) => get_entity_reference($user->getFirstAttribute('company'), 'communities', $bridge),
        'status' => fn () => true,
    ],
];
