import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  spacesTabs: {
    fields: ['uuid', { spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    })
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            spaces_tabs: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'SpacePage',
        params: {
          slug: spacesPages[0]?.spaces_tabs?.spaces?.slug[0]
        },
        query: { page: data?.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            spaces_tabs: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'SpacePage',
        params: {
          slug: spacesPages[0]?.spaces_tabs?.spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            spaces_tabs: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacePage',
          params: {
            slug: spacesPages[0]?.spaces_tabs?.spaces?.slug[0]
          },
          query: { page: data?.uuid }
        }
      }
    }
  }
}
