import { http } from '@inside-library/helpers/Http'

export const fetchSpacesListing = async () => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: ['uuid', 'content_type', 'slug', 'title', 'image', 'admin'],
      filters: {
        'status:eq': 1,
        'is_listed:eq': 1,
        sort: 'weight:asc'
      }
    })

    return data
  } catch (error) {
    throw new Error(error)
  }
}

export const fetchSpaces = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'banner',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (error) {
    throw new Error(error)
  }
}
