import SpacePage from '../pages/spaces/SpacePage'
import SpacesListingPage from '../pages/spaces/SpacesListingPage'
import { fetchSpaces, fetchSpacesListing } from '../fetch/spaces'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false },
    component: () => import('../pages/HomePage')
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      filtersInput: 'selectbox'
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/DirectoryPage')
  },
  {
    name: 'SpacesListingPage',
    path: '/espaces',
    meta: { customSlug: 'spaces' },
    component: withFetch(SpacesListingPage)(fetchSpacesListing)
  },
  {
    name: 'SpacePage',
    path: '/espaces/:slug',
    component: withFetch(SpacePage)(fetchSpaces)
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
