import Microsoft from '@inside-auth/components/login/extra-component/Microsoft'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  'inside-auth': {
    extraComponent: {
      is: Microsoft,
      link: `${origin}/saml/login`
    }
  },
  'inside-events': {
    calendarImportEnabled: true
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'contents', restrictions: [] }
      ]
    },
    shortcuts: {
      readonlyCount: 2
    }
  },
  'inside-news': {
    bookmarkEnabled: false
  }
}
