<?php

namespace Inside\CETP\Listeners;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class UserDefaultToolsListener
{
    public function handle(ContentFullyInsertedEvent $event): void
    {
        if (! $event->model instanceof Users) {
            return;
        }

        $user = $event->model;

        $defaultTools = Tools::query()
            ->whereIn('title', ['Malaise / Accident', 'Sécurité incendie'])
            ->orderBy('title')
            ->pluck('uuid');

        $userTools = $user->tools->pluck('uuid')->filter(fn (string $uuid) => ! $defaultTools->contains($uuid));

        $bridgeContent = new BridgeContent();
        $bridgeContent->contentUpdate(
            'users',
            [
                'uuid' => $user->uuid,
                'tools' => $defaultTools->merge($userTools)->all(),
            ]
        );
    }
}
