<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\NewsCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddNewsCategoriesHomepageField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField('news_categories', 'homepage', [
            'name' => 'homepage',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => "Afficher sur la page d'accueil",
            ],
            'description' => [
                'fr' => "Si la case n'est pas cochée, les actualités de cette catégorie ne s'afficheront pas sur la page d'accueil.",
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => true,
        ]);

        Artisan::call('models:rebuild');

        $bridgeContent = new BridgeContent();
        NewsCategories::each(fn (NewsCategories $category) => $bridgeContent->contentUpdate($category->content_type, [
            'uuid' => $category->uuid,
            'homepage' => true,
        ]));

        $this->finishUp();
    }
}
