<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class SetUsersDefaultTools extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $defaultTools = Tools::query()
            ->whereIn('title', ['Malaise / Accident', 'Sécurité incendie'])
            ->orderBy('title')
            ->pluck('uuid');

        $bridgeContent = new BridgeContent();
        Users::each(function (Users $users) use ($bridgeContent, $defaultTools) {
            $userTools = $users->tools->pluck('uuid')->filter(fn (string $uuid) => ! $defaultTools->contains($uuid));
            $bridgeContent->contentUpdate(
                'users',
                [
                    'uuid' => $users->uuid,
                    'tools' => $defaultTools->merge($userTools)->all(),
                ]
            );
        });
        $this->finishUp();
    }
}
